<?php
include_once '../config/database.php';
include_once '../classes/Candidate.php';
include_once '../classes/Source.php';
include_once '../classes/Profile.php';

session_start();

if (!isset($_SESSION['user_id']) || !isset($_GET['candidate_id'])) {
    echo '<div class="alert alert-danger">Access denied or invalid request.</div>';
    exit();
}

$database = new Database();
$db = $database->getConnection();

$candidate = new Candidate($db);
$source = new Source($db);
$profile = new Profile($db);

$candidate->candidate_id = $_GET['candidate_id'];
$candidate_data = $candidate->readOne();

if (!$candidate_data) {
    echo '<div class="alert alert-danger">Candidate not found.</div>';
    exit();
}

$sources_stmt = $source->read();
$profiles_stmt = $profile->read();
?>

<form method="POST" action="search-candidates.php" id="editCandidateForm">
    <input type="hidden" name="update_candidate" value="1">
    <input type="hidden" name="candidate_id" value="<?php echo htmlspecialchars($candidate_data['candidate_id']); ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="edit_name" class="form-label">Name</label>
            <input type="text" class="form-control" name="name" id="edit_name" value="<?php echo htmlspecialchars($candidate_data['name']); ?>" required>
        </div>
        <div class="col-md-6 mb-3">
            <label for="edit_email" class="form-label">Email</label>
            <input type="email" class="form-control" name="email" id="edit_email" value="<?php echo htmlspecialchars($candidate_data['email']); ?>" required>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="edit_phone" class="form-label">Phone</label>
            <input type="text" class="form-control" name="phone" id="edit_phone" value="<?php echo htmlspecialchars($candidate_data['phone']); ?>" required>
        </div>
        <div class="col-md-6 mb-3">
            <label for="edit_location" class="form-label">Location</label>
            <input type="text" class="form-control" name="location" id="edit_location" value="<?php echo htmlspecialchars($candidate_data['location']); ?>" required>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="edit_team_name" class="form-label">Team Name</label>
            <input type="text" class="form-control" name="team_name" id="edit_team_name" value="<?php echo htmlspecialchars($candidate_data['team_name']); ?>" required>
        </div>
        <div class="col-md-6 mb-3">
            <label for="edit_referral_code" class="form-label">Referral Code</label>
            <input type="text" class="form-control" name="referral_code" id="edit_referral_code" value="<?php echo htmlspecialchars($candidate_data['referral_code'] ?? ''); ?>">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="edit_lineup_date" class="form-label">Lineup Date</label>
            <input type="date" class="form-control" name="lineup_date" id="edit_lineup_date" value="<?php echo htmlspecialchars($candidate_data['lineup_date']); ?>" required>
        </div>
        <div class="col-md-6 mb-3">
            <label for="edit_source_id" class="form-label">Source</label>
            <select class="form-select" name="source_id" id="edit_source_id" required>
                <option value="">Select Source</option>
                <?php
                $sources_stmt->execute();
                while ($row = $sources_stmt->fetch(PDO::FETCH_ASSOC)):
                ?>
                    <option value="<?php echo $row['id']; ?>" <?php echo ($candidate_data['source_id'] == $row['id']) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($row['name']); ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="edit_profile_id" class="form-label">Profile</label>
            <select class="form-select" name="profile_id" id="edit_profile_id" required>
                <option value="">Select Profile</option>
                <?php
                $profiles_stmt->execute();
                while ($row = $profiles_stmt->fetch(PDO::FETCH_ASSOC)):
                ?>
                    <option value="<?php echo $row['id']; ?>" <?php echo ($candidate_data['profile_id'] == $row['id']) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($row['name']); ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="col-md-6 mb-3">
            <label for="edit_status" class="form-label">Status</label>
            <select class="form-select" name="status" id="edit_status" required>
                <option value="pending" <?php echo ($candidate_data['status'] == 'pending') ? 'selected' : ''; ?>>Pending</option>
                <option value="shortlisted" <?php echo ($candidate_data['status'] == 'shortlisted') ? 'selected' : ''; ?>>Shortlisted</option>
                <option value="selected" <?php echo ($candidate_data['status'] == 'selected') ? 'selected' : ''; ?>>Selected</option>
                <option value="rejected" <?php echo ($candidate_data['status'] == 'rejected') ? 'selected' : ''; ?>>Rejected</option>
                <option value="hold" <?php echo ($candidate_data['status'] == 'hold') ? 'selected' : ''; ?>>Hold</option>
                <option value="joined" <?php echo ($candidate_data['status'] == 'joined') ? 'selected' : ''; ?>>Joined</option>
                <option value="rescheduled" <?php echo ($candidate_data['status'] == 'rescheduled') ? 'selected' : ''; ?>>Rescheduled</option>
            </select>
        </div>
    </div>
    
    <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save me-1"></i>Update Candidate
        </button>
    </div>
</form>
