<?php
include_once '../config/database.php';
include_once '../classes/Candidate.php';

session_start();

if (!isset($_SESSION['user_id']) || !isset($_GET['candidate_id'])) {
    echo '<div class="alert alert-danger">Access denied or invalid request.</div>';
    exit();
}

$database = new Database();
$db = $database->getConnection();
$candidate = new Candidate($db);

$candidate->candidate_id = $_GET['candidate_id'];
$candidate_data = $candidate->readOne();

if (!$candidate_data) {
    echo '<div class="alert alert-danger">Candidate not found.</div>';
    exit();
}
?>

<div class="container-fluid p-4">
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="fas fa-user me-2"></i>Candidate Information</h6>
                </div>
                <div class="card-body">
                    <p><strong>ID:</strong> <?php echo htmlspecialchars($candidate_data['candidate_id']); ?></p>
                    <p><strong>Name:</strong> <?php echo htmlspecialchars($candidate_data['name']); ?></p>
                    <p><strong>Email:</strong> <?php echo htmlspecialchars($candidate_data['email']); ?></p>
                    <p><strong>Phone:</strong> <?php echo htmlspecialchars($candidate_data['phone']); ?></p>
                    <p><strong>Current Status:</strong> 
                        <span class="badge bg-primary"><?php echo strtoupper($candidate_data['status']); ?></span>
                    </p>
                </div>
            </div>
        </div>
        
        <div class="col-md-8">
            <form method="POST" action="search-candidates.php" id="interviewProcessForm">
                <input type="hidden" name="process_interview" value="1">
                <input type="hidden" name="candidate_id" value="<?php echo htmlspecialchars($candidate_data['candidate_id']); ?>">
                <input type="hidden" name="process_action" id="process_action" value="">
                <input type="hidden" name="final_status" id="final_status" value="">
                
                <!-- Step 1: Turn Up Status -->
                <div class="step-section active" id="step1">
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <h6 class="mb-0"><i class="fas fa-user-check me-2"></i>Step 1: Turn Up Status</h6>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle me-2"></i>
                                <strong>Did the candidate turn up for the interview?</strong>
                            </div>
                            <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                                <button type="button" class="btn btn-success btn-lg turn-up-btn" onclick="handleTurnUp(true)">
                                    <i class="fas fa-check me-2"></i>Yes, Turned Up
                                </button>
                                <button type="button" class="btn btn-danger btn-lg turn-up-btn" onclick="handleTurnUp(false)">
                                    <i class="fas fa-times me-2"></i>No, Didn't Turn Up
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 2a: Didn't Turn Up Options -->
                <div class="step-section" id="step2a" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-warning text-dark">
                            <h6 class="mb-0"><i class="fas fa-exclamation-triangle me-2"></i>Step 2: Candidate Didn't Turn Up</h6>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <strong>What would you like to do?</strong>
                            </div>
                            <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                                <button type="button" class="btn btn-info btn-lg" onclick="showRescheduleForm()">
                                    <i class="fas fa-calendar-alt me-2"></i>Reschedule Interview
                                </button>
                                <button type="button" class="btn btn-secondary btn-lg" onclick="showEndProcessForm()">
                                    <i class="fas fa-stop me-2"></i>End Process
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 2a1: Reschedule Form -->
                <div class="step-section" id="step2a1" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-info text-white">
                            <h6 class="mb-0"><i class="fas fa-calendar-alt me-2"></i>Reschedule Interview</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="next_lineup_date_rsch" class="form-label">Next Lineup Date</label>
                                    <input type="date" class="form-control" name="next_lineup_date_rsch" id="next_lineup_date_rsch" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="not_coming_reason_rsch" class="form-label">Reason for Not Coming</label>
                                    <select class="form-select" name="not_coming_reason_rsch" id="not_coming_reason_rsch" required>
                                        <option value="">Select Reason</option>
                                        <option value="personal_emergency">Personal Emergency</option>
                                        <option value="health_issues">Health Issues</option>
                                        <option value="transportation">Transportation Issues</option>
                                        <option value="family_issues">Family Issues</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                            </div>
                            <div class="d-flex justify-content-between">
                                <button type="button" class="btn btn-secondary" onclick="goBackToOptions()">
                                    <i class="fas fa-arrow-left me-2"></i>Back
                                </button>
                                <button type="button" class="btn btn-success" onclick="rescheduleCandidate()">
                                    <i class="fas fa-calendar-check me-2"></i>Reschedule
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 2a2: End Process Form -->
                <div class="step-section" id="step2a2" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-secondary text-white">
                            <h6 class="mb-0"><i class="fas fa-stop me-2"></i>End Interview Process</h6>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="end_reason" class="form-label">Reason for Ending Process</label>
                                <select class="form-select" name="end_reason" id="end_reason" required>
                                    <option value="">Select Reason</option>
                                    <option value="no_show_multiple">Multiple No-Shows</option>
                                    <option value="candidate_withdrew">Candidate Withdrew</option>
                                    <option value="position_filled">Position Already Filled</option>
                                    <option value="budget_constraints">Budget Constraints</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                            <div class="d-flex justify-content-between">
                                <button type="button" class="btn btn-secondary" onclick="goBackToOptions()">
                                    <i class="fas fa-arrow-left me-2"></i>Back
                                </button>
                                <button type="button" class="btn btn-danger" onclick="endProcess()">
                                    <i class="fas fa-stop me-2"></i>End Process
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 2b: Interview Result -->
                <div class="step-section" id="step2b" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0"><i class="fas fa-clipboard-check me-2"></i>Step 2: Interview Details & Result</h6>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle me-2"></i>
                                <strong>Great!</strong> Candidate turned up for the interview. Please provide interview details:
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="interview_type" class="form-label">Interview Type</label>
                                    <select class="form-select" name="interview_type" id="interview_type" required>
                                        <option value="">Select Interview Type</option>
                                        <option value="phone_screening">Phone Screening</option>
                                        <option value="technical_round">Technical Round</option>
                                        <option value="hr_round">HR Round</option>
                                        <option value="final_round">Final Round</option>
                                        <option value="group_discussion">Group Discussion</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="interviewer_name" class="form-label">Interviewer Name</label>
                                    <input type="text" class="form-control" name="interviewer_name" id="interviewer_name" required>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="interview_result" class="form-label">Interview Result</label>
                                <select class="form-select" name="interview_result" id="interview_result" onchange="handleInterviewResult()" required>
                                    <option value="">Select Result</option>
                                    <option value="shortlisted">Shortlisted for Next Round</option>
                                    <option value="selected">Selected</option>
                                    <option value="rejected">Rejected</option>
                                    <option value="hold">Put on Hold</option>
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label for="interview_notes" class="form-label">Interview Notes</label>
                                <textarea class="form-control" name="interview_notes" id="interview_notes" rows="3" placeholder="Add any additional notes about the interview..."></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 3a: Rejection -->
                <div class="step-section" id="step3a" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-danger text-white">
                            <h6 class="mb-0"><i class="fas fa-times-circle me-2"></i>Step 3: Rejection Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-danger">
                                <i class="fas fa-times-circle me-2"></i>
                                <strong>Candidate Rejected.</strong> Please provide rejection reason:
                            </div>
                            <div class="mb-3">
                                <label for="rejection_reason" class="form-label">Rejection Reason</label>
                                <select class="form-select" name="rejection_reason" id="rejection_reason" required>
                                    <option value="">Select Reason</option>
                                    <option value="technical_skills">Lack of Technical Skills</option>
                                    <option value="communication">Poor Communication</option>
                                    <option value="experience">Insufficient Experience</option>
                                    <option value="cultural_fit">Not a Cultural Fit</option>
                                    <option value="salary_expectations">Salary Expectations Too High</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                            <div class="text-center">
                                <button type="button" class="btn btn-danger btn-lg" onclick="confirmRejection()">
                                    <i class="fas fa-times me-2"></i>Confirm Rejection
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 3b: Hold -->
                <div class="step-section" id="step3b" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-warning text-dark">
                            <h6 class="mb-0"><i class="fas fa-pause-circle me-2"></i>Step 3: Hold Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-warning">
                                <i class="fas fa-pause-circle me-2"></i>
                                <strong>Candidate Put on Hold.</strong> Please provide hold reason:
                            </div>
                            <div class="mb-3">
                                <label for="hold_reason" class="form-label">Hold Reason</label>
                                <select class="form-select" name="hold_reason" id="hold_reason" required>
                                    <option value="">Select Reason</option>
                                    <option value="budget_approval">Waiting for Budget Approval</option>
                                    <option value="position_review">Position Under Review</option>
                                    <option value="other_candidates">Evaluating Other Candidates</option>
                                    <option value="client_decision">Waiting for Client Decision</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                            <div class="text-center">
                                <button type="button" class="btn btn-warning btn-lg" onclick="confirmHold()">
                                    <i class="fas fa-pause me-2"></i>Confirm Hold
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 3c: Shortlisted -->
                <div class="step-section" id="step3c" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-info text-white">
                            <h6 class="mb-0"><i class="fas fa-list-alt me-2"></i>Step 3: Schedule Next Interview</h6>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle me-2"></i>
                                <strong>Candidate Shortlisted!</strong> Schedule the next interview round:
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="next_interview_date" class="form-label">Next Interview Date</label>
                                    <input type="date" class="form-control" name="next_interview_date" id="next_interview_date" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="next_interview_type" class="form-label">Next Interview Type</label>
                                    <select class="form-select" name="next_interview_type" id="next_interview_type" required>
                                        <option value="">Select Type</option>
                                        <option value="technical_round">Technical Round</option>
                                        <option value="hr_round">HR Round</option>
                                        <option value="final_round">Final Round</option>
                                        <option value="client_round">Client Round</option>
                                    </select>
                                </div>
                            </div>
                            <div class="text-center">
                                <button type="button" class="btn btn-info btn-lg" onclick="scheduleNextInterview()">
                                    <i class="fas fa-calendar-plus me-2"></i>Schedule Next Interview
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 3d: Selected -->
                <div class="step-section" id="step3d" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0"><i class="fas fa-trophy me-2"></i>Step 3: Candidate Selected</h6>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-success">
                                <i class="fas fa-trophy me-2"></i>
                                <strong>Congratulations!</strong> Candidate has been selected. What's next?
                            </div>
                            <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                                <button type="button" class="btn btn-success btn-lg" onclick="proceedWithOffer()">
                                    <i class="fas fa-handshake me-2"></i>Proceed with Offer
                                </button>
                                <button type="button" class="btn btn-warning btn-lg" onclick="holdOffer()">
                                    <i class="fas fa-pause me-2"></i>Hold Offer
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 4: Offer Acceptance -->
                <div class="step-section" id="step4" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <h6 class="mb-0"><i class="fas fa-handshake me-2"></i>Step 4: Offer Acceptance</h6>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-primary">
                                <i class="fas fa-handshake me-2"></i>
                                <strong>Did the candidate accept the offer?</strong>
                            </div>
                            <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                                <button type="button" class="btn btn-success btn-lg" onclick="handleOfferAcceptance(true)">
                                    <i class="fas fa-check me-2"></i>Yes, Accepted
                                </button>
                                <button type="button" class="btn btn-danger btn-lg" onclick="handleOfferAcceptance(false)">
                                    <i class="fas fa-times me-2"></i>No, Declined
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 5: Joining Details -->
                <div class="step-section" id="step5" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-info text-white">
                            <h6 class="mb-0"><i class="fas fa-calendar-check me-2"></i>Step 5: Joining Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <i class="fas fa-calendar-check me-2"></i>
                                <strong>Set the expected joining date:</strong>
                            </div>
                            <div class="mb-3">
                                <label for="joining_date" class="form-label">Expected Joining Date</label>
                                <input type="date" class="form-control" name="joining_date" id="joining_date" required>
                            </div>
                            <div class="text-center">
                                <button type="button" class="btn btn-info btn-lg" onclick="setJoiningDetails()">
                                    <i class="fas fa-calendar-plus me-2"></i>Set Joining Date
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 6: Joining Confirmation -->
                <div class="step-section" id="step6" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0"><i class="fas fa-user-plus me-2"></i>Step 6: Joining Confirmation</h6>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-success">
                                <i class="fas fa-user-plus me-2"></i>
                                <strong>Did the candidate join on the expected date?</strong>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="actual_joining_date" class="form-label">Actual Joining Date</label>
                                    <input type="date" class="form-control" name="actual_joining_date" id="actual_joining_date">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="joining_feedback" class="form-label">Joining Feedback</label>
                                    <textarea class="form-control" name="joining_feedback" id="joining_feedback" rows="2" placeholder="Any feedback about the joining process..."></textarea>
                                </div>
                            </div>
                            <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                                <button type="button" class="btn btn-success btn-lg" onclick="handleJoiningConfirmation(true)">
                                    <i class="fas fa-check me-2"></i>Yes, Joined
                                </button>
                                <button type="button" class="btn btn-danger btn-lg" onclick="handleJoiningConfirmation(false)">
                                    <i class="fas fa-times me-2"></i>No, Didn't Join
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Process Complete -->
                <div class="step-section" id="process_complete" style="display: none;">
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h6 class="mb-0"><i class="fas fa-check-circle me-2"></i>Process Complete</h6>
                        </div>
                        <div class="card-body text-center">
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle me-2"></i>
                                <strong id="completion_message">The interview process has been completed successfully!</strong>
                            </div>
                            <div class="spinner-border text-success" role="status">
                                <span class="visually-hidden">Saving...</span>
                            </div>
                            <p class="mt-2">Saving data...</p>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
let currentStep = 1;
let selectedResult = '';

function handleTurnUp(turnedUp) {
    // Remove active class from all steps except step1
    document.querySelectorAll('.step-section:not(#step1)').forEach(step => {
        step.classList.remove('active');
        step.style.display = 'none';
    });
    
    // Highlight selected button
    document.querySelectorAll('.turn-up-btn').forEach(btn => {
        btn.classList.remove('selected');
    });
    
    const clickedButton = event.currentTarget;
    clickedButton.classList.add('selected');
    
    if (turnedUp) {
        // Show interview result selection step
        document.getElementById('step2b').style.display = 'block';
        document.getElementById('step2b').classList.add('active');
        currentStep = 2;
        setTimeout(() => {
            document.getElementById('step2b').scrollIntoView({ behavior: 'smooth', block: 'center' });
        }, 100);
    } else {
        // Show reschedule or end process options
        document.getElementById('step2a').style.display = 'block';
        document.getElementById('step2a').classList.add('active');
        currentStep = 2;
        setTimeout(() => {
            document.getElementById('step2a').scrollIntoView({ behavior: 'smooth', block: 'center' });
        }, 100);
    }
}

function handleInterviewResult() {
    const result = document.getElementById('interview_result').value;
    const interviewType = document.getElementById('interview_type').value;
    const interviewerName = document.getElementById('interviewer_name').value;
    
    if (!interviewType) {
        alert('Please select interview type first');
        document.getElementById('interview_type').focus();
        document.getElementById('interview_result').value = '';
        return;
    }
    
    if (!interviewerName.trim()) {
        alert('Please enter interviewer name');
        document.getElementById('interviewer_name').focus();
        document.getElementById('interview_result').value = '';
        return;
    }
    
    if (!result) {
        return;
    }
    
    selectedResult = result;
    
    // Hide all next steps first
    document.querySelectorAll('#step3a, #step3b, #step3c, #step3d').forEach(step => {
        step.style.display = 'none';
        step.classList.remove('active');
    });
    
    // Hide current step
    document.getElementById('step2b').classList.remove('active');
    
    // Show appropriate next step based on result
    switch(result) {
        case 'rejected':
            document.getElementById('step3a').style.display = 'block';
            document.getElementById('step3a').classList.add('active');
            document.getElementById('process_action').value = 'reject';
            document.getElementById('final_status').value = 'rejected';
            break;
        case 'hold':
            document.getElementById('step3b').style.display = 'block';
            document.getElementById('step3b').classList.add('active');
            document.getElementById('process_action').value = 'hold';
            document.getElementById('final_status').value = 'hold';
            break;
        case 'shortlisted':
            document.getElementById('step3c').style.display = 'block';
            document.getElementById('step3c').classList.add('active');
            document.getElementById('process_action').value = 'shortlist';
            document.getElementById('final_status').value = 'shortlisted';
            break;
        case 'selected':
            document.getElementById('step3d').style.display = 'block';
            document.getElementById('step3d').classList.add('active');
            document.getElementById('process_action').value = 'select';
            document.getElementById('final_status').value = 'selected';
            break;
    }
    
    currentStep = 3;
    setTimeout(() => {
        const activeStep = document.querySelector('.step-section.active');
        if (activeStep) {
            activeStep.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }
    }, 100);
}

function confirmRejection() {
    const reason = document.getElementById('rejection_reason').value;
    
    if (!reason) {
        alert('Please select rejection reason');
        document.getElementById('rejection_reason').focus();
        return;
    }
    
    if (confirm('Are you sure you want to reject this candidate? This will end the interview process.')) {
        document.getElementById('process_action').value = 'reject';
        document.getElementById('final_status').value = 'rejected';
        submitInterviewProcess();
    }
}

function confirmHold() {
    const reason = document.getElementById('hold_reason').value;
    
    if (!reason) {
        alert('Please select hold reason');
        document.getElementById('hold_reason').focus();
        return;
    }
    
    if (confirm('Are you sure you want to put this candidate on hold? This will end the current interview process.')) {
        document.getElementById('process_action').value = 'hold';
        document.getElementById('final_status').value = 'hold';
        submitInterviewProcess();
    }
}

function scheduleNextInterview() {
    const nextDate = document.getElementById('next_interview_date').value;
    const nextType = document.getElementById('next_interview_type').value;
    
    if (!nextDate) {
        alert('Please select next interview date');
        document.getElementById('next_interview_date').focus();
        return;
    }
    
    if (!nextType) {
        alert('Please select next interview type');
        document.getElementById('next_interview_type').focus();
        return;
    }
    
    if (confirm(`Schedule next ${nextType} interview for ${nextDate}?`)) {
        submitInterviewProcess();
    }
}

function proceedWithOffer() {
    // Show offer acceptance step
    document.getElementById('step3d').classList.remove('active');
    document.getElementById('step4').style.display = 'block';
    document.getElementById('step4').classList.add('active');
    currentStep = 4;
    setTimeout(() => {
        document.getElementById('step4').scrollIntoView({ behavior: 'smooth', block: 'center' });
    }, 100);
}

function holdOffer() {
    if (confirm('Hold the offer for this candidate? Status will be set to selected but offer will be on hold.')) {
        document.getElementById('process_action').value = 'select_hold_offer';
        document.getElementById('final_status').value = 'selected';
        submitInterviewProcess();
    }
}

function handleOfferAcceptance(accepted) {
    if (accepted) {
        // Show joining details step
        document.getElementById('step4').classList.remove('active');
        document.getElementById('step5').style.display = 'block';
        document.getElementById('step5').classList.add('active');
        currentStep = 5;
        setTimeout(() => {
            document.getElementById('step5').scrollIntoView({ behavior: 'smooth', block: 'center' });
        }, 100);
    } else {
        if (confirm('Candidate declined the offer. This will end the process with status "offer_declined".')) {
            document.getElementById('process_action').value = 'offer_declined';
            document.getElementById('final_status').value = 'offer_declined';
            submitInterviewProcess();
        }
    }
}

function setJoiningDetails() {
    const joiningDate = document.getElementById('joining_date').value;
    
    if (!joiningDate) {
        alert('Please enter expected joining date');
        document.getElementById('joining_date').focus();
        return;
    }
    
    // Show joining confirmation step
    document.getElementById('step5').classList.remove('active');
    document.getElementById('step6').style.display = 'block';
    document.getElementById('step6').classList.add('active');
    currentStep = 6;
    
    // Set the actual joining date to the expected joining date by default
    document.getElementById('actual_joining_date').value = joiningDate;
    
    setTimeout(() => {
        document.getElementById('step6').scrollIntoView({ behavior: 'smooth', block: 'center' });
    }, 100);
}

function handleJoiningConfirmation(joined) {
    const actualJoiningDate = document.getElementById('actual_joining_date').value;
    
    if (joined && !actualJoiningDate) {
        alert('Please enter actual joining date');
        document.getElementById('actual_joining_date').focus();
        return;
    }
    
    let confirmMessage = joined ? 
        'Confirm that the candidate has joined successfully?' :
        'Confirm that the candidate did not join?';
        
    if (confirm(confirmMessage)) {
        if (joined) {
            document.getElementById('process_action').value = 'joined';
            document.getElementById('final_status').value = 'joined';
        } else {
            document.getElementById('process_action').value = 'not_joined';
            document.getElementById('final_status').value = 'not_joined';
        }
        
        // Show completion message
        document.getElementById('step6').classList.remove('active');
        document.getElementById('process_complete').style.display = 'block';
        document.getElementById('process_complete').classList.add('active');
        
        // Update completion message based on joining status
        const completionMessage = document.getElementById('completion_message');
        if (joined) {
            completionMessage.innerHTML = 'The interview process has been completed successfully. Candidate has joined the organization!';
        } else {
            completionMessage.innerHTML = 'The interview process has been completed. Candidate was selected but did not join.';
        }
        
        setTimeout(() => {
            document.getElementById('process_complete').scrollIntoView({ behavior: 'smooth', block: 'center' });
        }, 100);
        
        // Submit after showing completion
        setTimeout(() => {
            submitInterviewProcess();
        }, 2000);
    }
}

// Reschedule and End Process functions
function showRescheduleForm() {
    document.getElementById('step2a').classList.remove('active');
    document.getElementById('step2a1').style.display = 'block';
    document.getElementById('step2a1').classList.add('active');
    setTimeout(() => {
        document.getElementById('step2a1').scrollIntoView({ behavior: 'smooth', block: 'center' });
    }, 100);
}

function showEndProcessForm() {
    document.getElementById('step2a').classList.remove('active');
    document.getElementById('step2a2').style.display = 'block';
    document.getElementById('step2a2').classList.add('active');
    setTimeout(() => {
        document.getElementById('step2a2').scrollIntoView({ behavior: 'smooth', block: 'center' });
    }, 100);
}

function goBackToOptions() {
    document.querySelectorAll('#step2a1, #step2a2').forEach(step => {
        step.classList.remove('active');
        step.style.display = 'none';
    });
    document.getElementById('step2a').style.display = 'block';
    document.getElementById('step2a').classList.add('active');
    setTimeout(() => {
        document.getElementById('step2a').scrollIntoView({ behavior: 'smooth', block: 'center' });
    }, 100);
}

function rescheduleCandidate() {
    const nextDate = document.getElementById('next_lineup_date_rsch').value;
    const reason = document.getElementById('not_coming_reason_rsch').value;
    
    if (!nextDate) {
        alert('Please select next lineup date');
        document.getElementById('next_lineup_date_rsch').focus();
        return;
    }
    
    if (!reason) {
        alert('Please select reason for not coming');
        document.getElementById('not_coming_reason_rsch').focus();
        return;
    }
    
    if (confirm('Reschedule this candidate for ' + nextDate + '?')) {
        document.getElementById('process_action').value = 'reschedule';
        document.getElementById('final_status').value = 'rescheduled';
        submitInterviewProcess();
    }
}

function endProcess() {
    const reason = document.getElementById('end_reason').value;
    
    if (!reason) {
        alert('Please select reason for ending process');
        document.getElementById('end_reason').focus();
        return;
    }
    
    if (confirm('Are you sure you want to end the interview process for this candidate? This action cannot be undone.')) {
        document.getElementById('process_action').value = 'end_process';
        document.getElementById('final_status').value = 'process_ended';
        submitInterviewProcess();
    }
}

function submitInterviewProcess() {
    // Get the form
    const form = document.getElementById('interviewProcessForm');
    
    // Add loading state to the clicked button
    if (event && event.target) {
        const submitBtn = event.target;
        submitBtn.classList.add('loading');
        submitBtn.disabled = true;
    }
    
    // Submit the form
    form.submit();
}

// Initialize the form when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    // Set minimum dates
    const today = new Date().toISOString().split('T')[0];
    const tomorrow = new Date(Date.now() + 24*60*60*1000).toISOString().split('T')[0];
    
    const nextLineupDate = document.getElementById('next_lineup_date_rsch');
    const nextInterviewDate = document.getElementById('next_interview_date');
    const joiningDate = document.getElementById('joining_date');
    const actualJoiningDate = document.getElementById('actual_joining_date');
    
    if (nextLineupDate) nextLineupDate.min = tomorrow;
    if (nextInterviewDate) nextInterviewDate.min = tomorrow;
    if (joiningDate) joiningDate.min = today;
    if (actualJoiningDate) actualJoiningDate.max = today;
});
</script>
