<?php
include_once '../config/database.php';
include_once '../classes/Candidate.php';
include_once '../classes/Interview.php';

session_start();

if (!isset($_SESSION['user_id']) || !isset($_GET['candidate_id'])) {
    echo '<div class="alert alert-danger">Access denied or invalid request.</div>';
    exit();
}

$database = new Database();
$db = $database->getConnection();

$candidate = new Candidate($db);
$interview = new Interview($db);

$candidate->candidate_id = $_GET['candidate_id'];
$candidate_data = $candidate->readOne();

if (!$candidate_data) {
    echo '<div class="alert alert-danger">Candidate not found.</div>';
    exit();
}

// Get interview history
$interviews_stmt = $interview->getByCandidateId($_GET['candidate_id']);
$interviews = $interviews_stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h6 class="mb-0"><i class="fas fa-user me-2"></i>Personal Information</h6>
                </div>
                <div class="card-body">
                    <table class="table table-borderless">
                        <tr>
                            <td><strong>Candidate ID:</strong></td>
                            <td><?php echo htmlspecialchars($candidate_data['candidate_id']); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Name:</strong></td>
                            <td><?php echo htmlspecialchars($candidate_data['name']); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Email:</strong></td>
                            <td><?php echo htmlspecialchars($candidate_data['email']); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Phone:</strong></td>
                            <td><?php echo htmlspecialchars($candidate_data['phone']); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Location:</strong></td>
                            <td><?php echo htmlspecialchars($candidate_data['location']); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Team Name:</strong></td>
                            <td><?php echo htmlspecialchars($candidate_data['team_name']); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Referral Code:</strong></td>
                            <td><?php echo htmlspecialchars($candidate_data['referral_code'] ?? 'N/A'); ?></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h6 class="mb-0"><i class="fas fa-briefcase me-2"></i>Application Information</h6>
                </div>
                <div class="card-body">
                    <table class="table table-borderless">
                        <tr>
                            <td><strong>Lineup Date:</strong></td>
                            <td><?php echo date('d-M-Y', strtotime($candidate_data['lineup_date'])); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Source:</strong></td>
                            <td><span class="badge bg-secondary"><?php echo htmlspecialchars($candidate_data['source_name']); ?></span></td>
                        </tr>
                        <tr>
                            <td><strong>Profile:</strong></td>
                            <td><?php echo htmlspecialchars($candidate_data['profile_name']); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Current Status:</strong></td>
                            <td>
                                <span class="badge bg-<?php 
                                    echo match($candidate_data['status']) {
                                        'pending' => 'warning',
                                        'shortlisted' => 'info',
                                        'selected' => 'success',
                                        'joined' => 'success',
                                        'rejected' => 'danger',
                                        'hold' => 'secondary',
                                        'rescheduled' => 'primary',
                                        default => 'secondary'
                                    };
                                ?>">
                                    <?php echo strtoupper($candidate_data['status']); ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Added Date:</strong></td>
                            <td><?php echo date('d-M-Y H:i', strtotime($candidate_data['added_date'])); ?></td>
                        </tr>
                        <tr>
                            <td><strong>Added By:</strong></td>
                            <td><?php echo htmlspecialchars($candidate_data['created_by_name'] ?? 'System'); ?></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <?php if (!empty($interviews)): ?>
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h6 class="mb-0"><i class="fas fa-history me-2"></i>Interview History</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Type</th>
                                    <th>Interviewer</th>
                                    <th>Result</th>
                                    <th>Status</th>
                                    <th>Notes</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($interviews as $int): ?>
                                <tr>
                                    <td><?php echo date('d-M-Y', strtotime($int['interview_date'])); ?></td>
                                    <td><?php echo htmlspecialchars($int['interview_type']); ?></td>
                                    <td><?php echo htmlspecialchars($int['interviewer_name']); ?></td>
                                    <td>
                                        <span class="badge bg-<?php 
                                            echo match($int['result']) {
                                                'shortlisted' => 'info',
                                                'selected' => 'success',
                                                'rejected' => 'danger',
                                                'hold' => 'secondary',
                                                default => 'primary'
                                            };
                                        ?>">
                                            <?php echo strtoupper($int['result']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo htmlspecialchars($int['status']); ?></td>
                                    <td><?php echo htmlspecialchars($int['notes'] ?? 'N/A'); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
    <button type="button" class="btn btn-primary" onclick="editCandidate('<?php echo $candidate_data['candidate_id']; ?>')" data-bs-dismiss="modal">
        <i class="fas fa-edit me-1"></i>Edit Candidate
    </button>
</div>
