<?php
class Interview {
    private $conn;
    private $table_name = "interviews";

    public $id;
    public $candidate_id;
    public $interview_type;
    public $interview_date;
    public $interviewer_name;
    public $result;
    public $notes;
    public $status;
    public $created_by;
    public $created_date;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function create() {
        $query = "INSERT INTO " . $this->table_name . " 
                  SET candidate_id=:candidate_id, interview_type=:interview_type, 
                      interview_date=:interview_date, interviewer_name=:interviewer_name,
                      result=:result, notes=:notes, status=:status, 
                      created_by=:created_by, created_date=NOW()";

        $stmt = $this->conn->prepare($query);

        // Sanitize
        $this->candidate_id = htmlspecialchars(strip_tags($this->candidate_id));
        $this->interview_type = htmlspecialchars(strip_tags($this->interview_type));
        $this->interview_date = htmlspecialchars(strip_tags($this->interview_date));
        $this->interviewer_name = htmlspecialchars(strip_tags($this->interviewer_name));
        $this->result = htmlspecialchars(strip_tags($this->result));
        $this->notes = htmlspecialchars(strip_tags($this->notes));
        $this->status = htmlspecialchars(strip_tags($this->status));
        $this->created_by = htmlspecialchars(strip_tags($this->created_by));

        // Bind values
        $stmt->bindParam(":candidate_id", $this->candidate_id);
        $stmt->bindParam(":interview_type", $this->interview_type);
        $stmt->bindParam(":interview_date", $this->interview_date);
        $stmt->bindParam(":interviewer_name", $this->interviewer_name);
        $stmt->bindParam(":result", $this->result);
        $stmt->bindParam(":notes", $this->notes);
        $stmt->bindParam(":status", $this->status);
        $stmt->bindParam(":created_by", $this->created_by);

        if($stmt->execute()) {
            return true;
        }
        return false;
    }

    public function getByCandidateId($candidate_id) {
        $query = "SELECT * FROM " . $this->table_name . " 
                  WHERE candidate_id = :candidate_id 
                  ORDER BY created_date DESC";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":candidate_id", $candidate_id);
        $stmt->execute();
        
        return $stmt;
    }
}
?>
