<?php
// This file processes interview form submissions

if ($_POST && isset($_POST['process_interview'])) {
    $candidate_id = $_POST['candidate_id'];
    $process_action = $_POST['process_action'];
    $final_status = $_POST['final_status'];
    
    // Create interview record
    $interview->candidate_id = $candidate_id;
    $interview->interview_type = $_POST['interview_type'] ?? '';
    $interview->interview_date = $_POST['interview_date'] ?? date('Y-m-d');
    $interview->interviewer_name = $_POST['interviewer_name'] ?? '';
    $interview->result = $_POST['interview_result'] ?? '';
    $interview->notes = $_POST['interview_notes'] ?? '';
    $interview->status = $process_action;
    $interview->created_by = $_SESSION['user_id'];
    
    // Save interview record
    $interview_saved = $interview->create();
    
    // Update candidate status
    $candidate->candidate_id = $candidate_id;
    if ($candidate->readOne()) {
        $candidate->status = $final_status;
        
        // Handle specific actions
        switch ($process_action) {
            case 'reschedule':
                $candidate->lineup_date = $_POST['next_lineup_date_rsch'];
                break;
            case 'shortlist':
                if (!empty($_POST['next_interview_date'])) {
                    $candidate->lineup_date = $_POST['next_interview_date'];
                }
                break;
            case 'joined':
                // Additional processing for joined candidates
                $joining_date = $_POST['actual_joining_date'] ?? date('Y-m-d');
                // You can add joining_date to candidates table if needed
                break;
        }
        
        $candidate_updated = $candidate->update();
        
        if ($interview_saved && $candidate_updated) {
            $success_message = "Interview process completed successfully!";
            header("Location: search-candidates.php?success=" . urlencode($success_message));
            exit();
        } else {
            $error_message = "Error processing interview. Please try again.";
            header("Location: search-candidates.php?error=" . urlencode($error_message));
            exit();
        }
    } else {
        $error_message = "Candidate not found.";
        header("Location: search-candidates.php?error=" . urlencode($error_message));
        exit();
    }
}
?>
